## 1.7.0 - 2011-07-06
### Added
- Add `genesis_human_time_diff()` to use on relative post dates, as a replacement for poor WP function.
- Add `genesis_canonical` filter.
- Add version number to `admin.js` to bust cache when updating Genesis.
- Add database version string to theme info stored in the database.
- Add private function to update database settings more easily.
- Add ability to return array values from database via `genesis_get_option()`.
- Add structural wrap fallback for child themes that do not load `init.php`.
- Add structural wrap support for sidebars.
- Add new layout images and visual selector feature.
- Add link to support forums on Theme Settings page.
- Add `.gallery-caption` and `.bypostauthor` classes (empty) to meet Theme Review guidelines.
- Add updated `.pot` file, now with 385 strings in total.
- Add class and method-level documentation for widget classes.

### Changed
- Improve settings page user interface to match new user interface for WordPress 3.2.
- Improve settings pages to be a single column.
- Improve organization of settings by combining some settings into other meta boxes, removing other meta boxes and conditionally hiding some depending on theme support for features.
- Improve user interface on User Profile page by amending widths of input and textarea fields.
- Improve wording on all admin pages to be clearer.
- Improve wording in notices, and to use WordPress wording where possible.
- Improve naming of layout choices.
- Improve capability check for Genesis pages by changing from `manage_options` to `edit_theme_options`.
- Improve old hook functions by formally deprecating them.
- Improve init to use WordPress function `require_if_theme_supports()` instead of using Genesis conditional.
- Improve widget organization and registration.
- Improve breadcrumbs to remove entry crumbs – allows Home crumb and separator to be remove, for instance.
- Improve README to be formatted for viewing inside WP Dashboard.
- Improve code standards by correcting whitespace and formatting issues in CSS.
- Improve code standards by correcting some whitespace issues in PHP.
- Improve styles for:
    - defaults
    - body
    - header
    - title
    - description
    - menus (including superfish)
    - breadcrumbs
    - headings (all levels)
    - blockquotes
    - inputs
    - ordered lists
    - list items
    - captions
    - taxonomy descriptions
    - images
    - post icons
    - featured images
    - sticky
    - avatars
    - post navigation
    - comments
    - subscribe-to-comments
    - sidebars
    - widgets

### Removed
- Remove "NOTE:" prefix for settings descriptions.
- Remove Header Right theme setting – sidebar now always registered but only shown if it contains a widget.
- Remove `strip_tags()` call on page title in breadcrumbs.
- Remove existing meta box order settings from the database.
- Remove `lib/functions/hooks.php` file as all contents have been moved to `lib/functions/deprecated.php`.

### Fixed
- Fix issue with menu separator having a class.
- Fix issues with post info and post meta not showing up on custom pages.
- Fix issue with feed redirection being too inclusive and breaking other plugins.
- Fix breadcrumb issue which stopped breadcrumbs from being turned off on blog pages for sites with a static front page.
- Fix Genesis to use `genesis_formatting_allowedtags()` instead of the global `$_genesis_formatting_allowedtags`.
- Fix load superfish script if custom menu widget is active.
- Fix Nav Extra posts feed to use RSS2 instead of RSS.
- Fix issue with toggle checkboxes in page / category widget checklist.
- Fix wording in latest tweets, categories menu, pages menu and user profile widgets to be translatable.
- Fix "Theme URL" to be "Theme URI".

### Security
- Security Audit by Mark Jaquith.
- Fix wrong escaping on comment permalink.
- Improve performance and security by sanitizing widget option values on save, instead of on display.
- Add a capability check before displaying Header and Footer scripts meta box.
- Add complete new settings sanitization class and API, aimed at core, extendable to child themes.
