## [2.7.0] - 2018-11-14
### Added
- Added soft PHP 5.3 requirement, with admin messaging.
- Added meta tag for breadcrumb position.
- Added ability to export or remove private data via the WordPress privacy tools.
- Added ability to autoload namespaced classes.
- Added `genesis_is_amp()` utility function for detecting when the request is an AMP URL.
- Added `minimum-scale` to the viewport meta tag when the request is an AMP URL.
- Added a `genesis_more_text` filter.
- Added a `/docs` folder for housing Genesis documentation.
- Added individual changelog files for each release.
- Added SEO support for SEOPress.
- Added Genesis version to the "At a Glance" dashboard widget.
- Added `rel="noopener noreferrer"` to new window links.
- Added `aria-current` to pagination for accessibility.

### Changed
- Use [Semantic Versioning](https://semver.org/) for all future releases.
- Use config file for breadcrumb arguments.
- Use Markup API to build breadcrumb links.
- Redirect to the "What's New" page on all upgrades, not just "major" ones.
- Change the license line in all file headers to "GPL-2.0-or-later".
- Use `wp_strip_all_tags()` instead of `strip_tags()`.
- Replace all references to "Copyblogger" with "StudioPress".
- Refresh `.editorconfig`.
- Use Markup API for opening and closing `entry-content` tags.
- Clear cache at the end of an upgrade.

### Fixed
- Fixed various code standards violations.
- Fixed various missing or incorrect inline documentation.
- Fixed issue where avatars were fetched even when the size to fetch is `0`.
- Fixed issue where `genesis_update_action_links()` was not returning an array.
- Fixed potential null pointer exceptions.
- Fixed misuses of `mb_strlen()`.
- Fixed Tiago Hillebrandt's Twitter link.

### Removed
- Deprecated `genesis_is_major_version()`.
- Deprecated third arg in `genesis_structural_wrap()`, intended as a return function.
- Removed direct file access block from `comments.php`.
- Removed an unused variable assignment in the entry content output function.
- Removed a duplicate `description` from `composer.json`.
- Removed tab stop on `aria-hidden` featured images.
- Remove all references to "Scribe".

[2.7.0]: https://github.com/studiopress/genesis/compare/2.6.1...2.7.0
