<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

namespace StudioPress\Genesis\Upgrade;

/**
 * Upgrade class. Called when `db_version` Genesis setting is below 130.
 *
 * @since 3.1.0
 */
class Upgrade_DB_130 implements Upgrade_DB_Interface {
	/**
	 * Upgrade method.
	 *
	 * @since 1.3.0
	 * @since 3.1.0 Moved to class method.
	 */
	public function upgrade() {
		genesis_update_settings(
			[
				'author_box_single' => genesis_get_option( 'author_box' ),
			]
		);

		genesis_update_settings(
			[
				'noindex_cat_archive'    => genesis_get_seo_option( 'index_cat_archive' ) ? 0 : 1,
				'noindex_tag_archive'    => genesis_get_seo_option( 'index_tag_archive' ) ? 0 : 1,
				'noindex_author_archive' => genesis_get_seo_option( 'index_author_archive' ) ? 0 : 1,
				'noindex_date_archive'   => genesis_get_seo_option( 'index_date_archive' ) ? 0 : 1,
				'noindex_search_archive' => genesis_get_seo_option( 'index_search_archive' ) ? 0 : 1,
				'noodp'                  => 1,
				'noydir'                 => 1,
				'canonical_archives'     => 1,
			],
			GENESIS_SEO_SETTINGS_FIELD
		);

		delete_transient( 'genesis-remote-store' );
	}
}
